CREATE LANGUAGE plpythonu;

CREATE OR REPLACE FUNCTION set_connection_value_str(key text, value text) RETURNS boolean AS
$$

if not 'mc_connectionvalues' in GD:
    GD['mc_connectionvalues'] = {}

GD['mc_connectionvalues'][key] = value
return True
$$ LANGUAGE plpythonu;


CREATE OR REPLACE FUNCTION set_connection_value_int(key text, value INTEGER) RETURNS boolean AS
$$

if not 'mc_connectionvalues' in GD:
    GD['mc_connectionvalues'] = {}

GD['mc_connectionvalues'][key] = value
return True
$$ LANGUAGE plpythonu;



CREATE OR REPLACE FUNCTION get_connection_value_int(key text) RETURNS text AS
$$

if not 'mc_connectionvalues' in GD:
    return None

if not key in GD['mc_connectionvalues']:
    return None

return int(GD['mc_connectionvalues'][key])

$$ LANGUAGE plpythonu;


CREATE OR REPLACE FUNCTION get_connection_value_str(key text) RETURNS text AS
$$

if not 'mc_connectionvalues' in GD:
    return None

if not key in GD['mc_connectionvalues']:
    return None

return str(GD['mc_connectionvalues'][key])

$$ LANGUAGE plpythonu;

CREATE OR REPLACE FUNCTION uses_in_memory_connectionvalues() RETURNS boolean AS
$$
    return 'mc_connectionvalues' in GD
$$ LANGUAGE plpythonu;